	function h = GRAY_MARKEL_2_2_h(k, c, Nsample)
	
	%	Computes the impulse response for the 2-multiplier structure
	%
	% 	Toolbox for DIGITAL FILTERS USING MATLAB 
	
	% 	Author: 		Lars Wanhammar 2011-02-11
	% 	Modified by: 	 
	% 	Copyright:		by authors - not released for commercial use
	% 	Version:		1
	% 	Known bugs:		 
	% 	Report bugs to:	Wanhammar@gmail.com
	
	N = length(k);
	x = zeros(1,N+1); b = zeros(1,N+1);
	x(1,N+1) = 1;	
	for n = 1:Nsample
		for m = N:-1:1
			x(1,m) = x(1,m+1) - k(m)*b(1,m);
			b(1,m+1) = k(m)*x(1,m) + b(1,m);
		end
		b(1,1) = x(1,1);
		x(1,N+1) = 0; y = 0;
		for m = 1:N+1
			y = y + c(m)*b(1,m);
		end
		h(n) = y;
	end
